//=============================================================================
// NoSuperWeapon - removes Redeemer and Painter
//=============================================================================
class MutEasySuperWeapon extends Mutator;

function bool CheckReplacement( Actor Other, out byte bSuperRelevant )
{
	bSuperRelevant = 0;
    if ( xWeaponBase(Other) != None )
    {
		if ( xWeaponBase(Other).WeaponType == class'SniperRifle' )
			xWeaponBase(Other).WeaponType = class'BeamCannon';
		else if ( xWeaponBase(Other).WeaponType == class'RocketLauncher' )
			xWeaponBase(Other).WeaponType = class'Redeemer';
		else
			return true;
	}
	else if ( WeaponPickup(Other) != None )
	{
		if ( string(Other.Class) == "xWeapons.SniperRiflePickup" )
			ReplaceWith( Other, "xPakII.BeamCannonPickup");
		else if ( string(Other.Class) == "xWeapons.RocketLauncherPickup" )
			ReplaceWith( Other, "xWeapons.RedeemerPickup");
		else
			return true;
	}
	else
		return true;

	return false;
}

defaultproperties
{
     GroupName="Arena"
     FriendlyName="Easy SuperWeapons"
     Description="SuperWeapon pickups are added to the map."
}
