//=============================================================================
// MutCooler - Lowers Adrenaline
//=============================================================================
class MutCooler extends Mutator;

#exec OBJ LOAD File=MutatorArt.utx

var() config int Rate,UpperLimit,LowerLimit;

// Don't call Actor PreBeginPlay() for Mutator
event PreBeginPlay()
{
    SetTimer(1.0,true);
}

function Timer()
{
    local Controller C;

    for (C = Level.ControllerList; C != None; C = C.NextController)
    {
	 	 if (C.Pawn != None && C.Adrenaline <= UpperLimit && C.Adrenaline >= LowerLimit )
        {
            C.Adrenaline -= Rate;
            if(C.Adrenaline < LowerLimit) {C.Adrenaline = LowerLimit;}
        }
    }
}

defaultproperties
{
     Rate=2
     UpperLimit=100
     LowerLimit=0
     GroupName="Cooler"
     FriendlyName="Cooler"
     Description="Constantly cools off adrenaline level.  || Net Support: Full | Bot Support: Full"
     ConfigMenuClassName="XPak.CoolerConfig"
}
