class MinigunHEAltFire extends MinigunFire;

function DoTrace(Vector Start, Rotator Dir)
{
    local Vector X, End, HitLocation, HitNormal, RefNormal;
    local Actor Other;
    local int Damage;
    local bool bDoReflect;
    local int ReflectNum;

    ReflectNum = 0;
    while (true)
    {
        bDoReflect = false;
        X = Vector(Dir);
        End = Start + TraceRange * X;

        Other = Trace(HitLocation, HitNormal, End, Start, true);

        if ( Other != None && (Other != Instigator || ReflectNum > 0) )
        {

												if (bReflective && Other.IsA('xPawn') && xPawn(Other).CheckReflect(HitLocation, RefNormal, DamageMin*0.25))
            {
                bDoReflect = true;
                HitNormal = Vect(0,0,0);
            }
            else if (!Other.bWorldGeometry)
            {
                Damage = (DamageMin + Rand(DamageMax - DamageMin)) * DamageAtten;
                Other.TakeDamage(Damage, Instigator, HitLocation, Momentum*X, DamageType);
                HitNormal = Vect(0,0,0);
            }
            else if ( WeaponAttachment(Weapon.ThirdPersonActor) != None )
				WeaponAttachment(Weapon.ThirdPersonActor).UpdateHit(Other,HitLocation,HitNormal);
        }
        else
        {
            HitLocation = End;
            HitNormal = Vect(0,0,0);
        }

        SpawnBeamEffect(Start, Dir, HitLocation, HitNormal, ReflectNum);
        Explode(HitLocation, HitNormal);
        if (bDoReflect && ++ReflectNum < 4)
        {
            //Log("reflecting off"@Other@Start@HitLocation);
            Start = HitLocation;
            Dir = Rotator(RefNormal); //Rotator( X - 2.0*RefNormal*(X dot RefNormal) );
        }
        else
        {
            break;
        }
    }
}

function BlowUp(vector HitLocation)
{
	HurtRadius(15, 45, DamageType, 250, HitLocation );
	MakeNoise(1.0);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	PlaySound(sound'WeaponSounds.BExplosion3',,2.5*TransientSoundVolume);
    if ( EffectIsRelevant(Location,false) )
    {
    	Spawn(class'HEBulletExplosion',,,HitLocation + HitNormal*16,rotator(HitNormal));
        Spawn(class'ExplosionCrap',,, HitLocation, rotator(HitNormal));
		   }

	BlowUp(HitLocation);
}

defaultproperties
{
     BarrelRotationsPerSec=1.000000
     FiringSound=Sound'WeaponSounds.Minigun.minialtfireb'
     WindUpTime=0.250000
     FiringForce="minialtfireb"
     DamageType=Class'XPak.DamTypeMinigunHEAlt'
     DamageMin=12
     DamageMax=12
     FireLoopAnimRate=3.000000
     PreFireTime=0.250000
     SmokeEmitterClass=Class'XEffects.MinigunAltMuzzleSmoke'
     Spread=0.040000
     AmmoPerFire=3
}
