class HeaterConfig extends GUIPage;

var moNumericEdit	Rate;
var moNumericEdit	Upper;
var moNumericEdit	Lower;

function InitComponent(GUIController MyController, GUIComponent MyOwner)
{
	Super.InitComponent(MyController, MyOwner);

	Rate  = moNumericEdit(Controls[3]);
 Upper = moNumericEdit(Controls[4]);
 Lower = moNumericEdit(Controls[5]);

 Rate.SetValue(class'MutHeater'.default.Rate);
 Upper.SetValue(class'MutHeater'.default.UpperLimit);
 Lower.SetValue(class'MutHeater'.default.LowerLimit);
}

function bool InternalOnClick(GUIComponent Sender)
{

	class'MutHeater'.default.Rate = Rate.GetValue();
	class'MutHeater'.default.UpperLimit = Upper.GetValue();
	class'MutHeater'.default.LowerLimit = Lower.GetValue();
	class'MutHeater'.static.StaticSaveConfig();

	Controller.CloseMenu(false);

	return true;
}

defaultproperties
{
	Begin Object Class=GUIButton name=DialogBackground
		WinWidth=1.0
		WinHeight=1.0
		WinTop=0
		WinLeft=0
		bAcceptsInput=false
		bNeverFocus=true
		StyleName="ComboListBox"
		bBoundToParent=true
		bScaleToParent=true
	End Object
	Controls(0)=GUIButton'DialogBackground'

	Begin Object Class=GUIButton Name=OkButton
		Caption="OK"
		WinWidth=0.2
		WinHeight=0.04
		WinLeft=0.4
		WinTop=0.6
		OnClick=InternalOnClick
	End Object
	Controls(1)=GUIButton'OkButton'

	Begin Object class=GUILabel Name=DialogText
		Caption="Heater"
		TextALign=TXTA_Center
		TextColor=(R=220,G=180,B=0,A=255)
		TextFont="UT2HeaderFont"
		WinWidth=1.000000
		WinHeight=32.000000
		WinLeft=0.000000
		WinTop=0.325000
	End Object
	Controls(2)=GUILabel'DialogText'

	Begin Object class=moNumericEdit Name=xRate
		WinWidth=0.200000
		WinHeight=0.010000
		WinLeft=0.25
		WinTop=0.4000
		Caption="Heater Rate"
		CaptionWidth=0.7
		MinValue=0
		MaxValue=3600
		ComponentJustification=TXTA_Left
		Hint="Rate that adrenaline raises"
	End Object
	Controls(3)=moNumericEdit'xRate'

	Begin Object class=moNumericEdit Name=xUpper
		WinWidth=0.300000
		WinHeight=0.010000
		WinLeft=0.50
		WinTop=0.4
		Caption="Upper Limit"
		CaptionWidth=0.7
		MinValue=0
		MaxValue=200
		ComponentJustification=TXTA_Left
		Hint="Adrenaline will raise up to this point"
	End Object
	Controls(4)=moNumericEdit'xUpper'

	Begin Object class=moNumericEdit Name=xLower
		WinWidth=0.300000
		WinHeight=0.010000
		WinLeft=0.50
		WinTop=0.50
		Caption="Lower Limit"
		CaptionWidth=0.7
		MinValue=0
		MaxValue=200
		ComponentJustification=TXTA_Left
		Hint="Adrenaline won't raise until it hits this point"
	End Object
	Controls(5)=moNumericEdit'xLower'


	WinLeft=0
	WinTop=0.3
	WinWidth=1
	WinHeight=0.4
	bRequire640x480=True
}
