class NVInteraction extends Interaction;

//places a sniper style HUD with blue forced completely on.
//Thanks goes PfPhoenix and the Mod Exemplar Project for making Radar2003,
//without I wouldn't have looked at interactions to do this with.

var NightVision NVMute;

var(Gfx) float testX;
var(Gfx) float testY;

var(Gfx) float borderX;
var(Gfx) float borderY;

var(Gfx) float focusX;
var(Gfx) float focusY;
var(Gfx) float innerArrowsX;
var(Gfx) float innerArrowsY;
var(Gfx) color ArrowColor;
var(Gfx) Color TargetColor;
var(Gfx) Color NoTargetColor;
var(Gfx) Color FocusColor;
var(Gfx) Color ChargeColor;

var(Gfx) vector RechargeOrigin;
var(Gfx) vector RechargeSize;

var transient float LastFOV;
var() bool zoomed;
var() xEmitter  chargeEmitter;

var Canvas C;

function PostRender(Canvas C)
{
	RenderOverlays(C);

	return;
}


// compensate for bright fog
simulated function SetZoomBlendColor(Canvas c)
{
    local Byte    val;
    local color   clr;
    local color   fog;

    clr.R = 0;
    clr.G = 0;
    clr.B = 255;
    clr.A = 255;

    c.DrawColor = clr;
}


simulated event RenderOverlays( Canvas Canvas )
{
	local float tileScaleX;
	local float tileScaleY;
	local float bX;
	local float bY;
	local float fX;
	local float fY;
	local float charge;

	local float tX;
	local float tY;

	local float barOrgX;
	local float barOrgY;
	local float barSizeX;
	local float barSizeY;

	 C = Canvas;

		charge = 1.0;

		tileScaleX = Canvas.SizeX / 640.0f;
		tileScaleY = Canvas.SizeY / 480.0f;

		bX = borderX * tileScaleX;
		bY = borderY * tileScaleY;
		fX = focusX * tileScaleX;
		fY = focusY * tileScaleX;

		tX = testX * tileScaleX;
		tY = testY * tileScaleX;

		barOrgX = RechargeOrigin.X * tileScaleX;
		barOrgY = RechargeOrigin.Y * tileScaleY;

		barSizeX = RechargeSize.X * tileScaleX;
		barSizeY = RechargeSize.Y * tileScaleY;

        SetZoomBlendColor(Canvas);

  Canvas.Style = 255;
		Canvas.SetPos(0,0);
  Canvas.DrawTile( Material'ZoomFB', Canvas.SizeX, Canvas.SizeY, 0.0, 0.0, 512, 512 ); // !! hardcoded size

		// draw border corners
		Canvas.SetPos(0,0);
		Canvas.DrawTile( Texture'SniperBorder', bX, bY, 0.0, 0.0, Texture'SniperBorder'.USize, Texture'SniperBorder'.VSize );

		Canvas.SetPos(Canvas.SizeX-bX,0);
		Canvas.DrawTile( Texture'SniperBorder', bX, bY, 0.0, 0.0, -Texture'SniperBorder'.USize, Texture'SniperBorder'.VSize );

		Canvas.SetPos(Canvas.SizeX-bX,Canvas.SizeY-bY);
		Canvas.DrawTile( Texture'SniperBorder', bX, bY, 0.0, 0.0, -Texture'SniperBorder'.USize, -Texture'SniperBorder'.VSize );

		Canvas.SetPos(0,Canvas.SizeY-bY);
		Canvas.DrawTile( Texture'SniperBorder', bX, bY, 0.0, 0.0, Texture'SniperBorder'.USize, -Texture'SniperBorder'.VSize );


		Canvas.DrawColor = FocusColor;
  Canvas.DrawColor.A = 255; // 255 was the original -asp. WTF??!?!?!
//		Canvas.Style = ERenderStyle.STY_Alpha;

		Canvas.SetPos((Canvas.SizeX*0.5)-fX,(Canvas.SizeY*0.5)-fY);
		Canvas.DrawTile( Texture'SniperFocus', fX*2.0, fY*2.0, 0.0, 0.0, Texture'SniperFocus'.USize, Texture'SniperFocus'.VSize );

  fX = innerArrowsX * tileScaleX;
		fY = innerArrowsY * tileScaleY;

  Canvas.DrawColor = ArrowColor;
  Canvas.SetPos((Canvas.SizeX*0.5)-fX,(Canvas.SizeY*0.5)-fY);
		Canvas.DrawTile( Texture'SniperArrows', fX*2.0, fY*2.0, 0.0, 0.0, Texture'SniperArrows'.USize, Texture'SniperArrows'.VSize );



}


function Tick(float DeltaTime)
{
	local int i;
	local Mutator M;
	local bool bFoundMute;

	bFoundMute = false;

	if(ViewPortOwner.Actor.Level.Game.BaseMutator != none) {
	Log("NVInteraction:"$ViewPortOwner.Actor.Level.Game.BaseMutator);
	for ( M=ViewPortOwner.Actor.Level.Game.BaseMutator; M!=None; M=M.NextMutator ) {
			if ( M.NextMutator.isA('NightVision') )
			{
				bFoundMute=true;
				break;
			}
	}

	if (!bFoundMute )
	{
		Master.RemoveInteraction(Self);
		return;
	}

	}
}


defaultproperties
{
     bActive=True
					bVisible=True
     bRequiresTick=true
}
