class InstantWeaponConfig extends GUIPage;

var array<class<Weapon> >	WeaponClass;
var array<String>			WeaponDesc;

var moComboBox				WeaponCombo,ArenaCombo;
var moCheckBox    UseArena;

function InitComponent(GUIController MyController, GUIComponent MyOwner)
{
	Super.InitComponent(MyController, MyOwner);

	WeaponCombo = moComboBox(Controls[4]);
	UseArena = moCheckBox(Controls[5]);
 ArenaCombo = moComboBox(Controls[7]);

 UseArena.Checked(	class'InstantWeapon'.default.bUseArena);

	// Spawn 'please wait' screen while we DLO the weapons
	if ( Controller.OpenMenu("xpakiii.LoadingWeaponIW") )
		LoadingWeaponIW(Controller.TopPage()).StartLoad(self);
}

function bool InternalOnClick(GUIComponent Sender)
{
	class'InstantWeapon'.default.WeaponClassName = WeaponCombo.GetExtra();
	class'InstantWeapon'.default.bUseArena = UseArena.IsChecked();
	class'InstantWeapon'.default.ArenaWeaponClassName = ArenaCombo.GetExtra();
	class'InstantWeapon'.static.StaticSaveConfig();

	Controller.CloseMenu(false);

	return true;
}

defaultproperties
{
	Begin Object Class=GUIButton name=DialogBackground
		WinWidth=1.0
		WinHeight=1.0
		WinTop=0
		WinLeft=0
		bAcceptsInput=false
		bNeverFocus=true
		StyleName="ComboListBox"
		bBoundToParent=true
		bScaleToParent=true
	End Object
	Controls(0)=GUIButton'DialogBackground'

	Begin Object Class=GUIButton Name=OkButton
		Caption="OK"
		WinWidth=0.2
		WinHeight=0.04
		WinLeft=0.4
		WinTop=0.6
		OnClick=InternalOnClick
	End Object
	Controls(1)=GUIButton'OkButton'

	Begin Object class=GUILabel Name=DialogText
		Caption="Instant Weapon"
		TextALign=TXTA_Center
		TextColor=(R=220,G=180,B=0,A=255)
		TextFont="UT2HeaderFont"
		WinWidth=1.000000
		WinHeight=32.000000
		WinLeft=0.000000
		WinTop=0.325000
	End Object
	Controls(2)=GUILabel'DialogText'

	Begin Object class=GUILabel Name=DialogText2
		Caption="Add weapon to inventory:"
		TextALign=TXTA_Left
		TextColor=(R=220,G=180,B=0,A=255)
		TextFont="UT2MenuFont"
		WinWidth=1.000000
		WinHeight=32.000000
		WinLeft=0.04000
		WinTop=0.390626
	End Object
	Controls(3)=GUILabel'DialogText2'

	Begin Object class=moComboBox Name=WeaponSelect
		WinWidth=0.431641
		WinHeight=0.04
		WinLeft=0.393750
		WinTop=0.390626
		Caption="Weapon"
		INIOption="@INTERNAL"
		CaptionWidth=0.3
		ComponentJustification=TXTA_Left
		bReadOnly=true
	End Object
	Controls(4)=moComboBox'WeaponSelect'

 Begin Object class=GUILabel Name=DialogText3
		Caption="Include Arena Weapon:"
		TextALign=TXTA_Left
		TextColor=(R=220,G=180,B=0,A=255)
		TextFont="UT2MenuFont"
		WinWidth=1.000000
		WinHeight=32.000000
		WinLeft=0.04000
		WinTop=0.527448
	End Object
	Controls(6)=GUILabel'DialogText3'

	Begin Object class=moCheckBox Name=UseArenaCheck
  WinWidth=0.03
		WinHeight=0.04
		WinTop=0.527448
		WinLeft=0.00000
		Caption=""
	End Object
	Controls(5)=moCheckBox'UseArenaCheck'

	Begin Object class=moComboBox Name=ArenaSelect
		WinWidth=0.431641
		WinHeight=0.04
		WinTop=0.527448
		WinLeft=0.393750
		Caption="Arena Weapon"
		INIOption="@INTERNAL"
		CaptionWidth=0.3
		ComponentJustification=TXTA_Left
		bReadOnly=true
	End Object
	Controls(7)=moComboBox'ArenaSelect'

	WinLeft=0
	WinTop=0.3
	WinWidth=1
	WinHeight=0.4
	bRequire640x480=True
}
