class InstantWeapon extends MutArena
					 config(user);

var() config string WeaponClassName;
var class<Weapon> WeaponClass;
var bool bInitialized;
var bool bAddWeapon;
var() config bool bUseArena;


function ModifyPlayer(Pawn Other)
{
  local Class<Weapon> W;

  W = class<Weapon>(DynamicLoadObject(WeaponClassName,class'Class'));

		if(Other.FindInventoryType(W) == None){
		  bAddWeapon=true;
		  Level.Game.AddDefaultInventory(Other);
		  bAddWeapon=false;
		  }

 	if ( NextMutator != None ) {NextMutator.ModifyPlayer(Other);}
}

/* return what should replace the default weapon
   mutators further down the list override earlier mutators
*/
function Class<Weapon> GetDefaultWeapon()
{
	local Class<Weapon> W;

if(!bAddWeapon) {

	if ( NextMutator != None )
	{
		W = NextMutator.GetDefaultWeapon();
		if ( W == None )
			W = MyDefaultWeapon();
	}
	else
		W = MyDefaultWeapon();
//		Log(W);
	return W;
	} else {
	  W = class<Weapon>(DynamicLoadObject(WeaponClassName,class'Class'));
//	  Log(W);
			return W;
	}

}

function bool CheckReplacement (Actor Other, out byte bSuperRelevant)
{
	if ( bUseArena )
	{
		if (  !bInitialized )
		{
			Initialize();
		}
		bSuperRelevant=0;
		if ( string(Other.Class) == WeaponClassName )
		{
			return True;
		}
		if ( xWeaponBase(Other) != None )
		{
			xWeaponBase(Other).WeaponType=ArenaWeaponClass;
		}
		else
		{
			if ( (Weapon(Other) != None) && (Other.Class != ArenaWeaponClass) )
			{
				if ( Other.IsA('BallLauncher') )
				{
					return True;
				}
				ReplaceWith(Other,ArenaWeaponClassName);
				return False;
			}
			else
			{
				if ( (WeaponPickup(Other) != None) && (string(Other.Class) != ArenaWeaponPickupClassName) )
				{
					ReplaceWith(Other,ArenaWeaponPickupClassName);
				}
				else
				{
					if ( (Ammo(Other) != None) && (string(Other.Class) != ArenaAmmoPickupClassName) )
					{
						ReplaceWith(Other,ArenaAmmoPickupClassName);
					}
					else
					{
						return True;
					}
				}
			}
		}
		return False;
	}
	else
	{
		return True;
	}
}

defaultproperties
{
    IconMaterialName="MutatorArt.nosym"
    ConfigMenuClassName="XPakIII.InstantWeaponConfig"
    GroupName="Arena"
    FriendlyName="Instant Weapon"
    Description="Add a new weapon to the default inventory.  Can also pick an arena weapon.    ||Net Support: Full |Bot Support: Full"
    WeaponClassName="XWeapons.RocketLauncher"
    bUseArena=false
    bAddWeapon=false
}
