class EMPPRojHeld extends EMPProj;

var() float         mHoldSpeedMin;
var() float         mHoldSpeedMax;
var() float         mHoldSpeedGainPerSec;
var() float         mHoldClampMax;

function PostBeginPlay()
{
    Super.PostBeginPlay();
    mHoldClampMax = (mHoldSpeedMax - mHoldSpeedMin) / mHoldSpeedGainPerSec;
}


function projectile SpawnProjectile(Vector Start, Rotator Dir)
{
    local EMPNade g;
    local vector X, Y, Z;
    local float pawnSpeed;

    g = Spawn(class'EMPNade', self,, Start, Dir);
    if (g != None)
    {
        Weapon.GetViewAxes(X,Y,Z);
        pawnSpeed = X dot Instigator.Velocity;

		if ( Bot(Instigator.Controller) != None )
			g.Speed = mHoldSpeedMax;
		else
			g.Speed = mHoldSpeedMin + HoldTime*mHoldSpeedGainPerSec;
		g.Speed = FClamp(g.Speed, mHoldSpeedMin, mHoldSpeedMax);
        g.Speed = pawnSpeed + g.Speed;
        //g.Speed = FClamp(g.Speed, mSpeedMin, mSpeedMax);
        g.Velocity = g.Speed * Vector(Dir);

        g.Damage *= DamageAtten;
    }
    return g;
}

function PlayPreFire()   {}
function PlayStartHold() {}
function PlayFiring()    {}
function PlayFireEnd()   {}

defaultproperties {
   ProjSpawnOffset=(X=25,Y=10,Z=-7)
   mHoldSpeedMin=60
   mHoldSpeedMax=3600
   mHoldSpeedGainPerSec=720
   MaxHoldTime=0.f
   bModeExclusive=true
   bFireOnRelease=true
}
