class EMPNade extends Grenade;

simulated function Explode(vector HitLocation, vector HitNormal)
{
	local actor HitActor;

	HurtRadius(Damage, DamageRadius, class'DamTypeEMPNade', MomentumTransfer, Location );

	Spawn(class'EMPCombo');
	if ( (Level.NetMode != NM_DedicatedServer) && EffectIsRelevant(Location,false) )
	{
		HitActor = Trace(HitLocation, HitNormal,Location - Vect(0,0,120), Location,false);
		if ( HitActor != None )
			Spawn(class'ComboDecal',self,,HitLocation, rotator(vect(0,0,-1)));
	}
	PlaySound(Sound'WeaponSounds.ShockRifle.ShockComboFire', SLOT_None,1.0,,800);
 Destroy();
}

defaultproperties
{
	   TossZ=+0.0
    HitEffectClass=class'XEffects.WallSparks'
    DampenFactor=0.5
    DampenFactorParallel=0.8
    ExplosionDecal=class'RocketMark'
    MyDamageType=class'DamTypeAssaultGrenade'
    Speed=900
    MaxSpeed=36000
    Damage=300
    DamageRadius=400.0
    MomentumTransfer=95000
    ExplodeTimer=1.0
    ImpactSound=Sound'WeaponSounds.P1GrenFloor1'
    Physics=PHYS_Falling
    DrawType=DT_StaticMesh
    StaticMesh=StaticMesh'E_Pickups.BombBall.FullBomb'
    DrawScale=3.0
    AmbientGlow=100
    bBounce=True
    bFixedRotationDir=True
    DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334)
}
