class EMPCombo extends ShockCombo;

simulated event PostBeginPlay()
{
    Super.PostBeginPlay();

    if (Level.NetMode != NM_DedicatedServer)
    {
        Spawn(class'ShockComboExpRing');
        Flare = Spawn(class'ShockComboFlare');
        //Spawn(class'ShockComboSphere');
        Spawn(class'ShockComboCore');
        Spawn(class'ShockComboSphereDark');
        Spawn(class'ShockComboVortex');
        Spawn(class'ShockComboWiggles');
        Spawn(class'ShockComboFlash');
    }
}

auto simulated state Combo
{
Begin:
    Sleep(0.9);
    //Spawn(class'ShockAltExplosion');
    if ( Flare != None )
    {
		Flare.mStartParticles = 2;
		Flare.mRegenRange[0] = 0.0;
		Flare.mRegenRange[1] = 0.0;
		Flare.mLifeRange[0] = 0.5;
		Flare.mLifeRange[1] = 0.5;
		Flare.mSizeRange[0] = 350;
		Flare.mSizeRange[1] = 350;
		Flare.mGrowthRate = -500;
		Flare.mAttenKa = 0.9;
	}
    LightType = LT_None;
}

defaultproperties
{
    DrawType=DT_None
    LifeSpan=2.0
    RemoteRole=ROLE_SimulatedProxy
    bNetTemporary=true
    ForceScale=-500.0
    ForceRadius=300.0
    ForceType=FT_Constant
    bDynamicLight=true
    LightType=LT_Steady
    LightEffect=LE_QuadraticNonIncidence
    LightBrightness=250
    LightHue=195
    LightSaturation=100
    LightRadius=10
    bCollideActors=true
}
