/*
Kakutou 2004!!!
	version 1.0
	Code and animations done by PsychoKick, circa 2002.
	Sounds ripped from Sega's Virtua Fighter PC and edited by PsychoKick.
	Very special thanks to the UT community for sharing the knowledge to make this mod possible.
	Dedicated to all who practice the martial arts, whether in reality or in games.
	UT2004 Code Modifications for Instant Action: Rythmix - Rythmix@gmail.com - www.rythm-nation.net
*/

//This replaces xPawn. Without this replacement it would be nigh-impossible to properly replicate
//all the animations. I originally wanted to restrict everything to the weapon code, but in the
//end this was the only practical way I could get the effects I wanted.
class K2k4xPawn extends xPawn
	config(User)
    dependsOn(xUtil)
    dependsOn(xPawnSoundGroup)
    dependsOn(xPawnGibGroup);

#exec ANIM IMPORT ANIM=K2k4Anims ANIMFILE=MODELS\K2k4Anims.PSA COMPRESS=0.9 MAXKEYS=9999999
#exec ANIM DIGEST ANIM=K2k4Anims USERAWINFO VERBOSE

#exec ANIM IMPORT ANIM=K2k4Anims1 ANIMFILE=MODELS\K2k4Anims1.PSA COMPRESS=0.9 MAXKEYS=9999999
#exec ANIM DIGEST ANIM=K2k4Anims1 USERAWINFO VERBOSE

#exec ANIM IMPORT ANIM=K2k4FlagAnims ANIMFILE=MODELS\K2k4FlagAnims.PSA COMPRESS=0.9 MAXKEYS=9999999
#exec ANIM DIGEST ANIM=K2k4FlagAnims USERAWINFO VERBOSE

#exec ANIM IMPORT ANIM=K2k4FlagAnims1 ANIMFILE=MODELS\K2k4FlagAnims1.PSA COMPRESS=0.9 MAXKEYS=9999999
#exec ANIM DIGEST ANIM=K2k4FlagAnims1 USERAWINFO VERBOSE

//var float BerRate, BerTween;   //removed for UT2K4 compatibility
var name PrevAnimAction;

replication
{
	reliable if (bNetDirty && (Role==ROLE_AUTHORITY))
        PrevAnimAction;
}

simulated function AssignInitialPose()
{
	super.AssignInitialPose();

	LinkSkelAnim(MeshAnimation'K2k4Anims');
	LinkSkelAnim(MeshAnimation'K2k4Anims1');
	LinkSkelAnim(MeshAnimation'K2k4FlagAnims');
	LinkSkelAnim(MeshAnimation'K2k4FlagAnims1');
}

function Tick(float DeltaTime)
{
	if ( (PlayerController(Controller) != none)
		&& (Weapon!=None)
		&& (PlayerController(Controller).myHUD!=None) )
	{
		if (Weapon.IsA('Unarmed'))
		{
			PlayerController(Controller).myHUD.bCrosshairShow = false;
			if (Unarmed(self.Weapon).bFlagFighting && (IdleWeaponAnim!='FlagReady') )
				IdleWeaponAnim='FlagReady';
			else if (!Unarmed(self.Weapon).bFlagFighting && (IdleWeaponAnim!='Ready') )
				IdleWeaponAnim='Ready';
		}
		else
		{
			PlayerController(Controller).myHUD.bCrosshairShow =
				PlayerController(Controller).myHUD.default.bCrosshairShow;
		}
	}
	PrevAnimAction = AnimAction;
	super.Tick(DeltaTime);
}

//Process unarmed animations first before processing the normal animations.
//simulated event SetAnimAction(name NewAction)
simulated function SetAnimAction(name NewAction)	//function seems to play smoother animation than event. Don't know why.
{
    AnimAction = NewAction;
//removed for UT2K4 compatibility
//	if ((self.CurrentCombo!= none) && (self.CurrentCombo.IsA('ComboBerserk')) )
//	{
//		BerRate=2.0;
//		BerTween=0.0;
//	}
//	else
//	{
//		BerRate=1.0;
//		BerTween=0.1;
//	}

	if( (AnimAction == 'AttackFast1') || (AnimAction == 'AttackFast2')
		|| (AnimAction == 'AttackStrong1') || (AnimAction == 'AttackStrong2') )
	{
//		PlayAnim(AnimAction, BerRate, BerTween);//, 0);   //removed for UT2K4 compatibility
		PlayAnim(AnimAction);
	}
	else if ( (AnimAction == 'AttackFast3') || (AnimAction == 'AttackFast4')
		|| (AnimAction == 'AttackStrong3') || (AnimAction == 'AttackStrong4') )
	{
//		PlayAnim(AnimAction, BerRate, BerTween);//, 0);   //removed for UT2K4 compatibility
		PlayAnim(AnimAction);
		bWaitForAnim=true;		//Animate the entire body for kick attacks
	}
	else if( (AnimAction == 'AttackFast1Rush') || (AnimAction == 'AttackFast2Rush')
		|| (AnimAction == 'AttackStrong1Rush') || (AnimAction == 'AttackStrong2Rush') )
	{
//		PlayAnim(AnimAction, BerRate, BerTween);//, 0);   //removed for UT2K4 compatibility
		PlayAnim(AnimAction);
	}
	else if ( (AnimAction == 'AttackFast3Rush') || (AnimAction == 'AttackFast4Rush')
		|| (AnimAction == 'AttackStrong3Rush') || (AnimAction == 'AttackStrong4Rush') )
	{
//		PlayAnim(AnimAction, BerRate, BerTween);//, 0);   //removed for UT2K4 compatibility
		PlayAnim(AnimAction);
		bWaitForAnim=true;
	}
	else if( (AnimAction == 'FlagFast1') || (AnimAction == 'FlagFast2')
		|| (AnimAction == 'FlagFast3') || (AnimAction == 'FlagFast4')
		|| (AnimAction == 'FlagFast1Rush') || (AnimAction == 'FlagFast2Rush')
		|| (AnimAction == 'FlagFast3Rush') || (AnimAction == 'FlagFast4Rush') )
	{
//		PlayAnim(AnimAction, BerRate, BerTween);//, 0);   //removed for UT2K4 compatibility
		PlayAnim(AnimAction);
	}
	else if( (AnimAction == 'FlagStrong1') || (AnimAction == 'FlagStrong2')
		|| (AnimAction == 'FlagStrong3') || (AnimAction == 'FlagStrong4')
		|| (AnimAction == 'FlagStrong1Rush') || (AnimAction == 'FlagStrong2Rush')
		|| (AnimAction == 'FlagStrong3Rush') || (AnimAction == 'FlagStrong4Rush') )
	{
//		PlayAnim(AnimAction, BerRate, BerTween);//, 0);   //removed for UT2K4 compatibility
		PlayAnim(AnimAction);
	}
	else if (AnimAction=='Guard')
	{
		PlayAnim(AnimAction);//, 1.0, 0.1);//, 0);
	}
	else if (AnimAction=='Ready')
	{
//		PlayAnim(AnimAction, BerRate, BerTween);//, 0);   //removed for UT2K4 compatibility
		PlayAnim(AnimAction);
	}
	else if (AnimAction=='FlagGuard')
	{
		PlayAnim(AnimAction);//, 1.0, 0.1);//, 0);
	}
	else if (AnimAction=='FlagReady')
	{
//		PlayAnim(AnimAction, BerRate, BerTween);//, 0);   //removed for UT2K4 compatibility
		PlayAnim(AnimAction);
	}

	super.SetAnimAction(NewAction);
}

simulated function bool SpecialCalcView(out actor ViewActor, out vector CameraLocation, out rotator CameraRotation )
{
	local PlayerController pc;

    if ((Level.Game!=None) && Level.Game.bGameEnded)
		return false;

	pc = PlayerController(Controller);

	if (pc == none)
		return false;

	CameraLocation = self.Location;

	if( pc.bBehindView ) //up and behind
	{
		pc.CalcBehindView(CameraLocation, CameraRotation, pc.CameraDist * self.default.CollisionRadius);
		if (Weapon.IsA('Unarmed'))
			CameraLocation.Z+=62;
	}
	else
		pc.CalcFirstPersonView( CameraLocation, CameraRotation );
	return true;
}

defaultproperties
{
    RequiredEquipment(1)="Kakutou2k4.Unarmed"
    bSpecialCalcView=True
    bReplicateAnimations=True
}
